function [ package_samples_bb ] = downconvert_package_from_passband( package_samples_pb, fs, f0, R )
%UNTITLED6 Summary of this function goes here
%   Detailed explanation goes here


% We have a sampling frequency fs=44100 and a carrier frequency of f0=fs/k
Ts = 1/fs;          % duration of one sample
T0 = 1/f0;          % duration of one period in the passband
Tr = 1/R;
delta_T = Tr/Ts;    % samples per symbol in passband

% create time axis
t_signal = Ts:Ts:length(package_samples_pb)*Ts;

% create cos and sin for the specified time axis
cos_shape = sqrt(2)*cos(2*pi*f0*t_signal);
sin_shape = -sqrt(2)*sin(2*pi*f0*t_signal);

% separate quadrature and inphase component
package_sc_up = package_samples_pb .* cos_shape;
package_ss_up = package_samples_pb .* sin_shape;

% lowpass filtering
lp_lag = 200; %50;
b =  2*R/fs*sinc(2*R/fs*(-lp_lag:lp_lag));
b = b.*hamming(2*lp_lag+1)';
%fvtool(b,1); % plot transfer function of lowpass filter

% zero phase filtering
package_sc_baseband_up = filtfilt(b,1, package_sc_up); %filter(b, 1, rx_sc_up);
package_ss_baseband_up = filtfilt(b,1, package_ss_up); %filter(b, 1, rx_ss_up);

package_baseband_up = package_sc_baseband_up + 1i*package_ss_baseband_up;

package_samples_bb = package_baseband_up;%(lp_lag:end-lp_lag-1);

end

